package com.jsf.event.queue;

import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.SessionScoped;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;

@ManagedBean @SessionScoped
public class UserBean {

	public String userName;

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	/* Method To Check Whether The User Request Has Administrator Role Or Not? */
	public void isAdmin(ComponentSystemEvent event) {	
		String checkUserRole =  (String) FacesContext.getCurrentInstance().getExternalContext().getSessionMap().get("role");		
		boolean isUserRoleEmpty = checkUserRole == null || checkUserRole.trim().length() == 0;
		if (isUserRoleEmpty) {			
			userName = "Java Geek";
			ConfigurableNavigationHandler navigationObj = (ConfigurableNavigationHandler) FacesContext.getCurrentInstance().getApplication().getNavigationHandler();
			navigationObj.performNavigation("not-admin-user");			
		} else if((!isUserRoleEmpty) && checkUserRole.equalsIgnoreCase("Administrator")) {
			/* Do Some Stuff If User Role Is Administrator */
		} else {
			/* Do Some Stuff If User Role Is Normal */
		}	
	}
}